"""
Loops and increasing distances produce a square spiral.

The step length grows on every turn while the turtle keeps rotating by 90°.
"""

import turtle


screen = turtle.Screen()
screen.setup(width=600, height=400)
screen.title("Python Turtle: Square Spiral")

pen = turtle.Turtle()
pen.speed("fast")
pen.color("royal blue")

turns = 30
step = 5

for i in range(turns):
    pen.forward(step * i)  # each side is longer than the previous one
    pen.right(90)

screen.mainloop()

